---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - PseudoForms
---

# Pseudo Form (classification)

> Performative/illusory coherence: appears structured by convention or presentation, but lacks closure support across layers.

---

## Definition

- Local cues or metadata suggest a Form, but critical closure predicates are missing
- Often relies on external scaffolding or agreement rather than internal stabilization

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Illusion | False signal | `Validate`, `Probe` |
| Scaffolding | External prop | `Support`, `Mock` |
| Convention | Agreement | `Protocol`, `Format` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Illusion | False appearance | "Looks real but isn't" |
| Scaffolding | External support | "Only works with help" |
| Convention | Social agreement | "We pretend it's true" |

### Crosswalk (bridge)

| Technical term | Humane term | Diagnostic meaning |
|---------------|-------------|-------------------|
| False signal | Illusion | How we're fooled |
| External prop | Support | What holds it up |
| Protocol | Agreement | What we accept |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Artifact check | False pattern |
| Networks | Vanity metric | Empty signal |
| Cognition | Confabulation | False memory |
| Systems | Mock stability | Pretend order |

---

## Invariants / Thresholds

Scale-dependent bounds:

### Micro Scale (ε-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ε | False signal | Quantum probe |
| λV | Gate illusion | Level check |

### Human Scale (ψA-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ψA | False coherence | Context switch |
| ∇S | Fake boundary | Support removal |

### Cosmic Scale (c-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| c | Causal illusion | Connection check |
| λV | False horizon | Field probe |

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | False structure | Pretend pattern |
| Human | λV | Curated gates | Selective view |
| Cosmic | ψA | Fake binding | False coherence |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Artifact | Instrument noise | False reading |
| Human | Convention | Agreement break | Social collapse |
| Cosmic | Illusion | Causal disconnect | Pattern dissolve |

---

## Diagnostic Checklist

Technical tests:
- [ ] Closure evidence at multiple k
- [ ] Behavior persists without λV curation
- [ ] Phase holds after delays/jitter
- [ ] Works without scaffolding

Humane tests:
- [ ] Real without support
- [ ] True under stress
- [ ] Survives context change
- [ ] Independent existence

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical validation nor experiential authenticity alone captures its full meaning.

---

## See Also

- [[Stable Form (classification)]]
- [[Apparent Form (classification)]]
- [[Collapsed Form (classification)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented